/*
 *  Besipiele.c
 *  GCD Beispiele
 *
 *  Created by Kai Brüning on 18.10.09.
 *  Copyright 2009 Heise. All rights reserved.
 *
 */

#include "Besipiele.h"
#include <dispatch/dispatch.h>
#include <stdio.h>
#include "Support.h"
#include "CallbackPrototypes.h"


void HelloWorld() {
	dispatch_queue_t myQueue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
	dispatch_async(myQueue, ^{ printf("Hallo Welt\n"); });
}

void CountWordsInBackground1(const char* filePath) {
	dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
		int wordCount = CountWords(filePath);
		printf("The word count is %i\n", wordCount);
	});
}

void CountWordsInBackground2(const char* filePath) {
	dispatch_queue_t replyQueue = dispatch_get_main_queue();
	
	dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
		int wordCount = CountWords(filePath);
		dispatch_async(replyQueue, ^{
			IntegrateWordCountInGUI(wordCount);
		});
	});
}

void CountWordsInBackground3(const char* filePaths[], int fileCount) {
	dispatch_queue_t workQueue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
	dispatch_queue_t replyQueue = dispatch_get_main_queue();
	
	for (int i = 0; i < fileCount; i++) {
		dispatch_async(workQueue, ^{
			int wordCount = CountWords(filePaths[i]);
			dispatch_async(replyQueue, ^{
				IntegrateWordCountOfOneFileInGUI(filePaths[i], wordCount);
			});
		});
	}
}

int CountWordsSync1(const char* filePaths[], int fileCount) {
	dispatch_queue_t workQueue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
	
	int wordCounts[fileCount];
	
	dispatch_apply(fileCount, workQueue, ^(size_t i) {
		wordCounts[i] = CountWords(filePaths[i]);
	});
	
	int totalCount = 0;
	for (int i = 0; i < fileCount; i++)
		totalCount += wordCounts[i];
	
	return totalCount;
}

int CountWordsSync2(const char* filePaths[], int fileCount) {
	dispatch_queue_t workQueue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
	
	dispatch_queue_t sumQueue = dispatch_queue_create("de.heise.sumQueue", 0);
	
	__block int totalCount = 0;
	
	dispatch_apply(fileCount, workQueue, ^(size_t i) {
		int wordCount = CountWords(filePaths[i]);
		dispatch_sync(sumQueue, ^{
			totalCount += wordCount;
		});
	});
	
	dispatch_release(sumQueue);
	
	return totalCount;
}

int CountWordsSync3(const char* filePaths[], int fileCount) {
	dispatch_queue_t workQueue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
	
	dispatch_queue_t sumQueue = dispatch_queue_create("de.heise.sumQueue", 0);
	
	dispatch_group_t sumGroup = dispatch_group_create();
	
	__block int totalCount = 0;
	
	dispatch_apply(fileCount, workQueue, ^(size_t i) {
		int wordCount = CountWords(filePaths[i]);
		dispatch_group_async(sumGroup, sumQueue, ^{
			totalCount += wordCount;
		});
	});
	
	dispatch_group_wait(sumGroup, DISPATCH_TIME_FOREVER);
	
	dispatch_release(sumQueue);
	dispatch_release(sumGroup);
	
	return totalCount;
}

